@extends('admin.layouts.app')
@section('panel')
<div class="row mb-3">
    <div class="col-lg-12">
        <div class="d-flex flex-wrap gap-4 justify-content-end">
            <a href="{{route('admin.services.create')}}" class="btn btn-sm btn--primary"><i class="fas fa-plus"></i> @lang('Add Service')</a>
            <button class="btn btn-sm btn--primary box--shadow1" id="actionButton" data-bs-toggle="dropdown">
                <i class="fas fa-plus"></i>
                @lang('Add API Services')
            </button>
            <div class="dropdown-menu p-0">
                @foreach($apiProviders as $apiList)
                <a href="{{ route('admin.services.get.api', $apiList->id) }}" class="dropdown-item">
                    <i class="las la-cloud-download-alt"></i>
                    {{__($apiList->name) }}
                </a>
                @endforeach
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="show-filter mb-3 text-end">
            <button type="button" class="btn btn--primary showFilterBtn btn-sm"><i class="las la-filter"></i>
                @lang('Filter')</button>
        </div>
        <div class="card responsive-filter-card mb-4">
            <div class="card-body">
                <form action="{{route('admin.services.filter')}}" method="get">
                    <div class="d-flex flex-wrap gap-4">
                        <div class="flex-grow-1">
                            <label>@lang('Name Search')</label>
                            <input type="text" name="search" class="form-control"
                                placeholder="@lang('Type Here')">
                        </div>
                        <div class="flex-grow-1">
                            <label>@lang('Category')</label>
                            <select name="category" id="category" class="form-control">
                                <option value="">@lang('Select Category')</option>
                                @foreach($categories as $category)
                                    <option value="{{$category->id}}" @if(@request()->category == $category->id) selected @endif>@lang($category->name)</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="flex-grow-1">
                            <label>@lang('Provider')</label>
                            <select name="provider" id="provider" class="form-control">
                                <option value="">@lang('Select Provider')</option>
                                @foreach($apiProviders as $provider)
                                    <option value="{{ $provider->id }}" @if(@request()->provider == $provider->id) selected @endif>@lang($provider->name)</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="flex-grow-1 align-self-end">
                            <button type="submit" class="btn btn--primary h-40 w-100"><i class="fas fa-check"></i>@lang('Apply')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('S/N')</th>
                                <th>@lang('Category Name')</th>
                                <th>@lang('Service Name')</th>
                                <th>@lang('Provider')</th>
                                <th>@lang('Price')</th>
                                <th>@lang('Drip Feed')</th>
                                <th>@lang('Status')</th>
                                <th>@lang('Action')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($services as $key=>$item)
                            <tr>
                                <td> {{$key+1}}</td>
                                <td>
                                    <span title="{{@$item->category->name}}">
                                        @if(strlen(__(@$item->category->name)) >40)
                                        {{substr(__(@$item->category->name), 0,40).'...' }}
                                        @else
                                        {{__(@$item->category->name)}}
                                        @endif
                                    </span>
                                </td>

                                <td>
                                    <span title="{{@$item->name}}">
                                        @if(strlen(__($item->name)) >40)
                                        {{substr(__($item->name), 0,40).'...' }}
                                        @else
                                        {{__($item->name)}}
                                        @endif
                                    </span>
                                </td>

                                <td>
                                    @if (@$item->provider->name)
                                    <span class="badge badge--primary" title="Api Provider">
                                        {{__(@$item->provider->name)}}</span>
                                    @else
                                    <span class="badge badge--warning">@lang('Manual')</span>
                                    @endif
                                </td>

                                <td>{{$general->cur_sym}} {{showAmount($item->price)}}</td>

                                <td>
                                    @php
                                      echo $item->drip_feedBadge($item->status);
                                    @endphp
                                </td>

                                <td>
                                    @php
                                    echo $item->statusBadge($item->status);
                                    @endphp
                                </td>

                                <td>
                                    <a href="{{route('admin.services.edit',$item->id)}}" title="@lang('Edit')" data-id="{{$item->id}}" class="btn btn-sm btn--primary"><i class="las la-edit"></i></a>
                                    <button title="@lang('Status Change')" data-id="{{$item->id}}" data-status="{{$item->status}}" class="btn btn-sm btn--danger statusChangeBtn"><i class="fas fa-sync-alt"></i></button>
                                    <button title="@lang('Details')" data-min="{{$item->min}}" data-max="{{$item->max}}" data-details="{{$item->details}}" data-name="{{$item->name}}" class="btn btn-sm btn--info detailsBtn"><i class="las la-eye"></i></button>
                                </td>

                            </tr>
                            @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                            </tr>
                            @endforelse

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if($services->hasPages())
            <div class="card-footer py-4">
                {{ paginateLinks($services) }}
            </div>
            @endif
        </div><!-- card end -->
    </div>
</div>

{{-- status change modal --}}
<div id="statusChangeModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">@lang('Status Change Confirmation!')</h5>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="{{route('admin.services.status.change')}}" method="POST">
                @csrf
                <div class="modal-body">
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">@lang('Status')</label>
                            <select name="status" class="form-control">
                                <option @if(1) selected @endif value="1">@lang('Active')</option>
                                <option @if(0) selected @endif value="0">@lang('Inactive')</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary">@lang('Confirm')</button>
                </div>
            </form>
        </div>
    </div>
</div>



{{-- details --}}
<div class="modal fade" id="detailsModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="title"></h4>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <p> <strong>@lang('Details'):</strong><span id="servicedescription"></span></p>
                <p><strong>@lang('min'):</strong> <span id="min"></span></p>
                <p><strong>@lang('max') :</strong> <span id="max"></span></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="close btn btn--primary" data-bs-dismiss="modal" aria-label="Close">
                    @lang('Close')
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('script')
<script>
    "use strict";

        $('.statusChangeBtn').on('click', function () {
            var modal = $('#statusChangeModal');
            modal.find('input[name=id]').val($(this).data('id'));
            var status = $(this).data('status');
            modal.find('select[name=status]').val(status);
            modal.modal('show');
        });


        // details
        $('.detailsBtn').on('click', function () {
            var modal = $('#detailsModal');
            var title = $(this).data('name');
                var description = $(this).data('details');
                var min = $(this).data('min');
                var max = $(this).data('max');
                $('#title').text(title);
                $('#servicedescription').text(description);
                $('#min').text(min);
                $('#max').text(max);

            modal.modal('show');
        });

</script>
@endpush
