@extends($activeTemplate.'layouts.frontend')
@section('content')
<!-- ==================== Service Start Here ==================== -->
<section class="single-service-area mt-5 mt-4 ">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <form action="{{route('service.filter')}}" method="get">
                    <div class="search-body account-form">
                        <div class="row gy-4">
                            <div class="col-lg-4">
                                <div>
                                    <input type="text" class="form--control" name="search"
                                        placeholder="@lang('Search by title')">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <select class="form-select form--control" name="category">
                                    <option value="">@lang('----select categories----')</option>
                                    @foreach($allCategories as $category)
                                    <option value="{{$category->id}}">{{__($category->name)}}</option>
                                    @endforeach

                                </select>
                            </div>
                            <div class="col-lg-4">
                                <div>
                                    <button type="submit" class="btn btn--base w-100">@lang('Search')</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

@foreach($categories as $item)
<section class="single-service-area pt-80 py-80 ">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="section-heading d-flex align-items-center">
                    <div class="experience__icon mb-1 me-2">
                        <img src="{{ getImage(getFilePath('category').'/'.@$item->logo,getFileSize('category'))}}" alt="@lang('image')">
                    </div>
                    <h4 class="section-heading__title">
                        @if(strlen(__(@$item->name)) >40)
                        {{substr(__(@$item->name), 0,40).'...' }}
                        @else
                        {{__(@$item->name)}}
                        @endif
                    </h4>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            @forelse($item->services??[] as $value)
            <div class="col-lg-3 col-md-3 col-sm-4 col-6">
                <div class="single-service text-center">
                    <div class="single-service__icon">
                        <img src="{{ getImage(getFilePath('category').'/'.@$item->logo,getFileSize('category'))}}"
                            alt="image">
                    </div>
                    <div class="single-service__content">
                        <h3 class="title" title="{{__($value->name)}}">
                            @if(strlen(__($value->name)) >20)
                            {{substr(__($value->name), 0,20).'...' }}
                            @else
                            {{__($value->name)}}
                            @endif
                            <br>
                            <span class="mt-2">{{$general->cur_sym}} {{formatPrice($value->price)}}</span>
                        </h3>
                    </div>
                    <div class="single-service__bottom">
                        <a href="{{route('user.service.order',$value->id)}}" class="btn--small ">@lang('Order Now')</a>
                    </div>
                </div>
            </div>
            @empty
            <h4 class=" text-mute text-center" colspan="100%">{{__($emptyMessage) }}</h4>
            @endforelse
        </div>
    </div>
</section>
@endforeach
<div class="container">
    <div class="row my-3">
        <div class="col-12">
            @if($categories->hasPages())
            <div class="py-4">
                {{ paginateLinks($categories) }}
            </div>
            @endif
        </div>
    </div>
</div>
<!--==================== Service End Here ==================== -->
@endsection
