@extends($activeTemplate.'layouts.master')
@section('content')
<div class="col-xl-9 col-lg-12">
    <div class="dashboard-body">
        <div class="dashboard-body__bar">
            <span class="dashboard-body__bar-icon"><i class="las la-bars"></i></span>
        </div>
        <div class="row gy-4 justify-content-center">
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <div class="dashboard-card">
                    <span class="banner-effect-1"></span>
                    <div class="dashboard-card__icon">
                        <i class="las la-hand-holding-usd"></i>
                    </div>
                    <div class="dashboard-card__content">
                        <h5 class="dashboard-card__title">@lang('Balance')</h5>
                        <h4 class="dashboard-card__amount">{{$general->cur_sym}}{{ showAmount($user->balance)}}</h4>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="{{route('user.order.index')}}">
                <div class="dashboard-card">
                    <span class="banner-effect-1"></span>
                    <div class="dashboard-card__icon">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="dashboard-card__content">
                        <h5 class="dashboard-card__title">@lang('Orders') </h5>
                        <h4 class="dashboard-card__amount">{{$orderCount}}</h4>
                    </div>
                </div>
                </a>
            </div>
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="{{route('user.brnad.package.index')}}">
                <div class="dashboard-card">
                    <span class="banner-effect-1"></span>
                    <div class="dashboard-card__icon">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="dashboard-card__content">
                        <h5 class="dashboard-card__title">@lang('Brand Package Orders') </h5>
                        <h4 class="dashboard-card__amount">{{$brandOrderCount}}</h4>
                    </div>
                </div>
                </a>
            </div>
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="{{route('user.transactions')}}">
                    <div class="dashboard-card">
                        <span class="banner-effect-1"></span>
                        <div class="dashboard-card__icon">
                            <i class="fas fa-funnel-dollar"></i>
                        </div>
                        <div class="dashboard-card__content">
                            <h5 class="dashboard-card__title">@lang('Transactions')</h5>
                            <h4 class="dashboard-card__amount">{{$transectionCount}}</h4>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="{{route('user.deposit.history')}}">
                    <div class="dashboard-card">
                        <span class="banner-effect-1"></span>
                        <div class="dashboard-card__icon">
                            <i class="fas fa-clipboard-check"></i>
                        </div>
                        <div class="dashboard-card__content">
                            <h5 class="dashboard-card__title">@lang('Deposit Log')</h5>
                            <h4 class="dashboard-card__amount">{{$depositCount}}</h4>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="{{route('ticket')}}">
                    <div class="dashboard-card">
                        <span class="banner-effect-1"></span>
                        <div class="dashboard-card__icon">
                            <i class="fas fa-clipboard-check"></i>
                        </div>
                        <div class="dashboard-card__content">
                            <h5 class="dashboard-card__title">@lang('Tickets')</h5>
                            <h4 class="dashboard-card__amount">{{$ticketCount}}</h4>
                        </div>
                    </div>
                </a>
            </div>
        </div>

        <div class="row mb-4 mt-4">
            <div class="col-12">
                <div class="chart account-form">
                    <div class="chart-bg">
                        <h5>@lang('Monthly Deposit History')</h5>
                        <div id="account-chart"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<script src="{{asset('assets/admin/js/apexcharts.min.js')}}"></script>
<script>
    (function () {
        "use strict";
        var options = {
            chart: {
                type: 'area',
                stacked: false,
                height: '310px'
            },
            stroke: {
                width: [0, 3],
                curve: 'smooth'
            },
            plotOptions: {
                bar: {
                    columnWidth: '50%'
                }
            },
            colors: ['#00adad', '#67BAA7'],
            series: [{
        name: '@lang("Deposits")',
        type: 'area',
        data: @json($depositsChart['values'])
    }],
    fill: {
        opacity: [0.85, 1],
                },
    labels: @json($depositsChart['labels']),
    markers: {
        size: 0
    },
    xaxis: {
        type: 'text'
    },
    yaxis: {
        min: 0
    },
    tooltip: {
        shared: true,
            intersect: false,
                y: {
            formatter: function (y) {
                if (typeof y !== "undefined") {
                    return "$ " + y.toFixed(0);
                }
                return y;

            }
        }
    },
    legend: {
        labels: {
            useSeriesColors: true
        },
        markers: {
            customHTML: [
                function () {
                    return ''
                },
                function () {
                    return ''
                }
            ]
        }
    }
            }
    var chart = new ApexCharts(
        document.querySelector("#account-chart"),
        options
    );
    chart.render();
    }) ();
</script>
@endpush
