@php
    $about = getContent('theme_two_about.content',true);
    $aboutElements = getContent('theme_two_about.element',false,4);
@endphp
<!--========================== About Start ==========================-->
<section class="about py-80">
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-6 col-12 thumb mb-lg-0 mb-4">
                <img src="{{getImage(getFilePath('frontend').'/theme_two_about'.'/'.@$about->data_values->about_image)}}" alt="@lang('image')">
            </div>
            <div class="col-lg-6 col-12 my-auto">
                <div class="title-two">
                    <h4>{{__(@$about->data_values->heading)}}</h4>
                    <p>{{__(@$about->data_values->sub_heading)}}</p>
                </div>
                <div class="row info">
                    @foreach($aboutElements as $item)
                    <div class="col-xl-6 col-md-6 col-12">
                        <p><i class="fas fa-check-circle"></i>{{__($item->data_values->content)}}</p>
                    </div>
                    @endforeach
                </div>
                <div class="details">
                    <div class="row gy-4">
                        <div class="col-lg-6 col-12">
                            <div class="card">
                                <h4>@lang('Our Mission')</h4>
                                <p>
                                    @if(strlen(__(@$about->data_values->mission_short_description)) >54)
                                    {{substr(__(@$about->data_values->mission_short_description), 0,54).'...' }}
                                    @else
                                    {{__(@$about->data_values->mission_short_description)}}
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-lg-6 col-12">
                            <div class="card">
                                <h4>@lang('Our Vision')</h4>
                                <p>
                                    @if(strlen(__(@$about->data_values->vission_short_description)) >54)
                                    {{substr(__(@$about->data_values->vission_short_description), 0,54).'...' }}
                                    @else
                                    {{__(@$about->data_values->vission_short_description)}}
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--========================== About End ==========================-->
