@php
    $service = getContent('we_provide.content',true);
    $serviceElements = getContent('we_provide.element',false);
@endphp
<!-- ==================== provide Start ==================== -->
<section class="provide py-80">
    <div class="container">
        <div class="title">
            <h4> {{__(@$service->data_values->heading)}}</h4>
            <p>{{__(@$service->data_values->sub_heading)}}</p>
        </div>
        <div class="row gy-4">
            @forelse($serviceElements as $item)
            <div class="col-xl-3 col-lg-4 col-md-6 col-12">
                <div class="card">
                    <div class="d-flex align-items-center">
                        <div class="icon">
                            @php echo $item->data_values->service_icon; @endphp
                        </div>
                        <div>
                            <h4>
                                @if(strlen(__(@$item->data_values->title)) >50)
                                {{substr(__(@$item->data_values->title), 0,50).'...' }}
                                @else
                                {{__(@$item->data_values->title)}}
                                @endif
                            </h4>
                        </div>
                    </div>
                    <div class="info">
                        <p> @if(strlen(strip_tags(@$item->data_values->description)) >140)
                            {{substr(strip_tags(@$item->data_values->description), 0,140).'...' }}
                            @else
                            {{strip_tags(@$item->data_values->description)}}
                            @endif
                        </p>
                    </div>
                </div>
            </div>
            @empty
            <h2 class="text-center">{{__($emptyMessage)}}</h2>
            @endforelse
        </div>
    </div>
</section>
<!-- ==================== provide End ==================== -->
