@extends($activeTemplate.'layouts.frontend')
@section('content')
<!-- ==================== Services Start ==================== -->
<section class="services py-80">
    <div class="container">
        <form action="{{route('service.filter')}}" method="get">
            <div class="search-body">
                <div class="row gy-4">
                    <div class="col-lg-4">
                        <div>
                            <input type="text" class="form--control" name="search" placeholder="@lang('Search by title')">
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <select class="form-select form--control" name="category">
                            <option value="">@lang('----select categories----')</option>
                            @foreach($allCategories as $category)
                            <option value="{{$category->id}}">{{__($category->name)}}</option>
                            @endforeach

                        </select>
                    </div>
                    <div class="col-lg-4">
                        <div>
                            <button type="submit" class="btn btn--base w-100">@lang('Search')</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <div class="row gy-4">
            @foreach($categories as $item)
            <div class="col-12">
                <div class="accordion custom--accordion2" id="accordionExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading{{ $loop->index }}">
                            <button class="accordion-button d-flex align-items-center {{ $loop->index == 0 ? '' : 'collapsed' }}" type="button"
                                data-bs-toggle="collapse" data-bs-target="#collapse{{ $loop->index }}" aria-expanded="{{$loop->index == 0 ? 'true': 'false'}}">
                                <img src="{{ getImage(getFilePath('category').'/'.@$item->logo)}}" class="icon" alt="@lang('image')">
                                @if(strlen(__(@$item->name)) >40)
                                {{substr(__(@$item->name), 0,40).'...' }}
                                @else
                                {{__(@$item->name)}}
                                @endif
                            </button>
                        </h2>
                        <div id="collapse{{ $loop->index }}" class="accordion-collapse collapse {{$loop->index == 0 ? 'show': ''}}" aria-labelledby="heading{{ $loop->index }}" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <div>
                                    <table class="custom-table">
                                        <thead>
                                            <tr>
                                                <th>@lang('ID')</th>
                                                <th>@lang('Name')</th>
                                                <th>@lang('Rate Per 1K')</th>
                                                <th>@lang('Min')</th>
                                                <th>@Lang('Max')</th>
                                                <th>@lang('Action')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($item->services??[]  as $value)
                                            <tr>
                                                <td data-label="@lang('ID')">{{$value->id}}</td>
                                                <td data-label="@lang('Name')" title="{{$value->name}}">
                                                    @if(strlen(__($value->name)) >20)
                                                    {{substr(__($value->name), 0,20).'...' }}
                                                    @else
                                                    {{__($value->name)}}
                                                    @endif
                                                </td>
                                                <td data-label="@lang('Rate Per 1K')">{{$general->cur_sym}}{{formatPrice($value->price)}}</td>
                                                <td data-label="@lang('Min')">{{$value->min}}</td>
                                                <td data-label="@lang('Max')">{{$value->max}}</td>
                                                <td data-label="@lang('Action')"><a href="{{route('user.service.order',$value->id)}}" title="Order Now"><i class="fas fa-cart-arrow-down"></i></a></td>
                                            </tr>
                                            @empty
                                            <tr>
                                                <td class="text-muted text-center" colspan="100%">{{__($emptyMessage) }}</td>
                                            </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endforeach
        </div>
        <div class="row my-3">
            <div class="col-12">
                @if($categories->hasPages())
                <div class="py-4">
                    {{ paginateLinks($categories) }}
                </div>
                @endif
            </div>
        </div>
    </div>
</section>
<!-- ==================== Services End ==================== -->
@endsection

