
<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="table-content">
        <div class="body-area">
            <form action="<?php echo e(route('user.service.order.place')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="row gy-3">
                    <div class="col-lg-6">
                        <div class="row gy-3">
                            <div class="account-form__content">
                                <h3 class="account-form__title mb-2"><?php echo e($pageTitle); ?> </h3>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="category" class="form--label"><?php echo app('translator')->get('Category'); ?></label>
                                    <select name="category" class="form-select form--control select categoryId" required>
                                        <option selected><?php echo app('translator')->get('Select Category'); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Service'); ?></label>
                                    <select class="form-select form--control services select" name="service">
                                        <option selected><?php echo app('translator')->get('Select Service'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="link" class="form--label"> <?php echo app('translator')->get('Your Link'); ?></label>
                                    <input type="text" class="form--control" id="link" name="link"
                                        placeholder="<?php echo app('translator')->get('Your Link'); ?>">
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="quantity" class="form--label"><?php echo app('translator')->get('Quantity'); ?></label>
                                    <input type="number" class="form--control quantity" id="quantity" min="1"
                                        name="quantity" placeholder="<?php echo app('translator')->get('Quantity'); ?>">
                                </div>
                            </div>


                            <div class="form-group drip_feed d-none col-lg-12">
                                <label class="form--label"><?php echo app('translator')->get('Drip feed'); ?></label>
                                <input type="checkbox" name="drip_feed" class="custom-switch-checkbox dripfeed" id="status" value="1">
                            </div>

                            <div class="drip_feed_check d-none col-lg-12">
                                <div class="row gy-3">
                                    <div class="col-sm-6">
                                        <div class="form-group drip_feed">
                                            <label class="form--label"><?php echo app('translator')->get('Runs'); ?></label>
                                            <input type="number" id="runs" name="runs" class="form--control runs"
                                                value="<?php echo e(old('runs')); ?>">

                                        </div>
                                    </div>
                                    <div class="col-sm-6 ">
                                        <div class="form-group drip_feed">
                                            <label class="form--label"><?php echo app('translator')->get('Interval (in minutes)'); ?></label>
                                            <input type="number" name="interval" class="form--control interval"
                                                value="<?php echo e(old('interval')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-12">
                                        <div class="form-group drip_feed">
                                            <label class="form--label"><?php echo app('translator')->get('Total Quantity'); ?></label>
                                            <input type="text" class="form--control total_quantity" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label for="quantity" class="form--label"><?php echo app('translator')->get('Price'); ?></label>
                                    <input step="any" type="number" class="form--control price"
                                        placeholder="<?php echo app('translator')->get('Price'); ?>">
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-lg-6">
                        <div class="row gy-3 service-details">
                            <div class="account-form__content">
                                <h3 class="account-form__title mb-2"><?php echo app('translator')->get('Service Details'); ?> </h3>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Service name'); ?></label>
                                    <input type="text" class="form--control d_service_name" placeholder="<?php echo app('translator')->get('Service Name'); ?>" disabled>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Minimum'); ?></label>
                                    <input class="form--control d_service_min" placeholder="<?php echo app('translator')->get('Min'); ?>" disabled>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Maximum'); ?></label>
                                    <input class="form--control d_service_max" placeholder="<?php echo app('translator')->get('Max'); ?>" disabled>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Price per 1k'); ?></label>
                                    <input class="form--control d_service_price" placeholder="<?php echo app('translator')->get('0.00'); ?>" disabled>
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="form-group">
                                    <label class="form--label"><?php echo app('translator')->get('Description'); ?></label>
                                    <textarea class="form--control d_service_description" placeholder="<?php echo app('translator')->get('Description'); ?>" disabled rows="12"></textarea>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="form-group">
                            <label class="form--label" for="mass_order"><?php echo app('translator')->get('Note'); ?></label>
                            <textarea name="note" class="form--control" cols="30" rows="10"></textarea>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="agree" name="check">
                            <label class="form-check-label" for="agree"><?php echo app('translator')->get('Yes, i have confirmed the order!'); ?></label>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <button type="submit" class="btn btn--base w-100">
                            <?php echo app('translator')->get('Place Order'); ?> <i class="fas fa-arrow-right"></i>
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function () {
        "use strict";

        $(document).on('change', '.categoryId', function (e) {
            var categoryId = $('option:selected', this).val();
            getService(categoryId);
        });

        $(document).on('change', '.services', function () {
            var serviceId = $('option:selected', this).val();
            getServiceDetails(serviceId)
        });

        var total = 1;
        $(document).on('change keyup', '.quantity,.runs', function () {
            var quan = $('.quantity').val();
            var run = $('.runs').val();
            var total = quan * run;
            $('.total_quantity').val(total);

        });

        $(document).on('change keyup', '.quantity', function () {
            var quan = $('.quantity').val();
            var pri = $('.d_service_price').val();
            var total = ((quan * pri) / 1000).toFixed(2);
            $('.price').val(total);
        });

        $(document).on('change', '.dripfeed', function () {
            var isChecked = $(this).is(":checked");
            var elementToShowHide = $('.drip_feed_check');

            if (isChecked) {
                elementToShowHide.removeClass('d-none');
                $(this).val(1);
            } else {
                elementToShowHide.addClass('d-none');
                $(this).val(0);
            }
        });

        function getService(categoryId) {

            $.ajax({
                url: "<?php echo e(route('user.get.ajax.services')); ?>",
                type: "get",
                data: {categoryId: categoryId},
                success: function (data) {
                    $('.services').html('');

                    if (data.length) {

                        $(data).each(function (key, val) {

                        $('.services').append('<option value="' + val.id + '">' + val.name + '</option>');

                        });

                        let serviceId = !data[0].id ? serviceId : data[0].id;
                        getServiceDetails(serviceId);

                    }else{

                        $('.service-details').find('input').val('');
                    }
                }
            })
        }

        function getServiceDetails(serviceId) {

            $.ajax({
                type: "get",
                data: {serviceId: serviceId},
                url: "<?php echo e(route('user.get.ajax.service.details')); ?>",
                success: function (data) {

                    var price = parseFloat(data.price).toFixed(4);

                    $('.d_service_name').val(data.name);
                    $('.d_service_min').val(data.min);
                    $('.d_service_max').val(data.max);
                    $('.d_service_price').val(price);
                    $('.d_service_description').val(data.description);
                    if (data.drip_feed == 1) {
                        $('.drip_feed').removeClass('d-none');
                        $('.dripfeed').prop('checked', true).trigger('change');
                    } else {
                        $('.drip_feed').addClass('d-none');
                        $('.dripfeed').prop('checked', false).trigger('change');
                    }
                }
            });
        }

    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/user/orders/create.blade.php ENDPATH**/ ?>