<div class="sidebar">
    <div class="sidebar__inner">
        <div class="sidebar-top-inner">
            <div class="sidebar__logo">
                <a href="<?php echo e(route('home')); ?>" class="sidebar__main-logo">
                    <img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo_white.png', '?' . time())); ?>"
                        alt="<?php echo e(config('app.name')); ?>">
                </a>
                <div class="navbar__left">
                    <button class="navbar__expand">
                        <i class="fas fa-bars"></i>
                    </button>
                    <button class="sidebar-mobile-menu">
                        <i class="fas fa-bars"></i>
                    </button>
                </div>
            </div>
            <div class="sidebar__menu-wrapper">
                <ul class="sidebar__menu p-0">
                    <li class="sidebar-menu-item ">
                        <a href="<?php echo e(route('user.home')); ?>">
                            <i class="menu-icon fas fa-home"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Dashboard'); ?></span>
                        </a>
                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a href="javascript:void(0)">
                            <i class="menu-icon fas fa-cart-plus"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Create Orders'); ?></span>
                        </a>
                        <ul
                            class="sidebar-submenu <?php echo e(isActiveRoute('user.order.create')|| isActiveRoute('user.mass.order') ? 'd-block' : ''); ?>">
                            <li class="sidebar-menu-item <?php echo e(Route::is('user.order.create') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('user.order.create')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('New Order'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.mass.order.create')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('Mass Order'); ?> </span>
                                </a>
                            </li>
                        </ul>

                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a href="javascript:void(0)">
                            <i class="menu-icon fas fa-cart-arrow-down"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Orders'); ?></span>
                        </a>
                        <ul
                            class="sidebar-submenu
                        <?php echo e(isActiveRoute('user.order.index')|| isActiveRoute('user.order.pending')|| isActiveRoute('user.order.processing')||isActiveRoute('user.order.complete')|| isActiveRoute('user.order.refund')||isActiveRoute('user.order.cancelle') ? 'd-block' : ''); ?>">
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.order.index')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('All Orders'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.order.pending')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('Pending'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.order.processing')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('Processing'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.order.complete')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('Complete'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.order.refund')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('Refunded'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.order.cancelle')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('Cancelled'); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-menu-item ">
                        <a href="<?php echo e(route('user.brnad.package.index')); ?>">
                            <i class="menu-icon fas fa-gift"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Branding Orders'); ?></span>
                        </a>
                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a href="javascript:void(0)">
                            <i class="menu-icon fas fa-dollar-sign"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Deposit'); ?></span>
                        </a>
                        <ul class="sidebar-submenu <?php echo e(isActiveRoute('user.deposit') ? 'd-block' : ''); ?>">
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.deposit')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('Deposit Now'); ?></span>
                                </a>
                            </li>
                            <li class="sidebar-menu-item">
                                <a href="<?php echo e(route('user.deposit.history')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('Deposit Log'); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-menu-item <?php echo e(Route::is('user.transactions') ? 'active' : ''); ?>">
                        <a href="<?php echo e(route('user.transactions')); ?>">
                            <i class="menu-icon fas fa-exchange-alt"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Transactions'); ?></span>
                        </a>
                    </li>

                    <li class="sidebar-menu-item sidebar-dropdown">
                        <a href="javascript:void(0)">
                            <i class="menu-icon fas fa-headset"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Support Tickets'); ?></span>
                        </a>
                        <ul class="sidebar-submenu <?php echo e(isActiveRoute('ticket') ? 'd-block' : ''); ?>">
                            <li
                                class="sidebar-menu-item sidebar-menu-sub-menu <?php echo e(Route::is('ticket') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('ticket')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('My Tickets'); ?></span>
                                </a>
                            </li>
                            <li
                                class="sidebar-menu-item sidebar-menu-sub-menu <?php echo e(Route::is('ticket.open') ? 'active' : ''); ?>">
                                <a href="<?php echo e(route('ticket.open')); ?>" class="nav-link">
                                    <i class="menu-icon las la-ellipsis-h"></i>
                                    <span class="menu-title"><?php echo app('translator')->get('New Ticket'); ?></span>
                                </a>
                            </li>
                        </ul>
                    </li>

                    <li class="sidebar-menu-item">
                        <a href="<?php echo e(route('user.api.index')); ?>">
                            <i class="menu-icon fas fa-code"></i>
                            <span class="menu-title"><?php echo app('translator')->get('Api'); ?></span>
                        </a>
                    </li>

                </ul>
            </div>
        </div>
         <div class="sidebar-support-box d-grid align-items-center bg-img"
               data-background="<?php echo e(asset($activeTemplateTrue . 'images/sidebar-bg.png')); ?>">
               <div class="sidebar-support-icon">
                   <i class="fas fa-question-circle"></i>
               </div>
               <div class="sidebar-support-content">
                   <h4 class="title"><?php echo app('translator')->get('Need Help'); ?>?</h4>
                   <p><?php echo app('translator')->get('Please contact our support'); ?>.</p>
                   <div class="sidebar-support-btn">
                       <a href="<?php echo e(route('ticket.open')); ?>" class="btn btn--base w-100 mt-2"><?php echo app('translator')->get('Get Support'); ?></a>
                   </div>
               </div>
           </div>
    </div>
</div>

<?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/components/side_nav.blade.php ENDPATH**/ ?>