
<?php
    $contact = getContent('contact_us.content',true);
    $socialIcons = getContent('social_icon.element',false);
    $languages = App\Models\Language::all();
    $pages = App\Models\Page::where('tempname',$activeTemplate)->get();
?>
<!-- ==================== Header End Here ==================== -->
<div class="header" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg">
            <a class="navbar-brand logo" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo.png', '?'.time())); ?>" alt="<?php echo e(config('app.name')); ?>">
            </a>
            <button class="navbar-toggler header-button" type="button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false"
                aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu mx-auto ps-lg-4 ps-0">
                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Request::url() == url('/').'/'.$page->slug ? 'active' : ''); ?>" aria-current="page" href="<?php echo e(route('pages',[$page->slug])); ?>"><?php echo e(__($page->name)); ?></a>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="nav-end d-lg-flex d-block align-items-center py-lg-0 py-1">
                    <div class="d-flex mx-2">
                        <div class="icon">
                            <i class="fas fa-globe"></i>
                        </div>
                        <select class="select-dir langSel">
                            <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($language->code); ?>" <?php if(Session::get('lang')===$language->code): ?>
                                selected <?php endif; ?>><?php echo e(__($language->name)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mx-lg-0 mx-2">
                        <?php if(auth()->guard()->check()): ?>
                        <a class="btn btn--base mt-3 mt-lg-0" href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                        <?php else: ?>
                        <a class="btn btn--base mt-3 mt-lg-0" href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Sign In'); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</div>
<!-- ==================== Header End Here ==================== -->
<?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/components/header.blade.php ENDPATH**/ ?>