<?php
$package = getContent('package.content',true);
$services = App\Models\Services::where('status',1)->with('category')->inRandomOrder()->take(12)->get();
?>
<!-- ==================== Service Start Here ==================== -->
<section class="experience-area section-bg py-80 ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="section-heading  text-center">
                    <span class="subtitle"><?php echo e(__($package->data_values->top_heading)); ?></span>
                    <h2 class="section-heading__title">
                        <?php echo e(__($package->data_values->heading)); ?>

                    </h2>
                    <p class="section-heading__desc"><?php echo e(__($package->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-2 col-md-3 col-sm-4 col-6">
                <div class="single-service text-center">
                    <div class="single-service__icon">
                        <img src="<?php echo e(getImage(getFilePath('category').'/'.@$item->category->logo)); ?>" alt="logo">
                    </div>
                    <div class="single-service__content">
                        <h3 class="title" title="<?php echo e(__($item->name)); ?>">
                            <?php if(strlen(__($item->name)) >20): ?>
                            <?php echo e(substr( __($item->name), 0,20).'...'); ?>

                            <?php else: ?>
                            <?php echo e(__($item->name)); ?>

                            <?php endif; ?>
                            <br>
                            <span class="mt-2"><?php echo e($general->cur_sym); ?> <?php echo e(showAmount($item->price)); ?></span>
                        </h3>
                    </div>
                    <div class="single-service__bottom">
                        <a href="<?php echo e(route('user.direct.order',$item->id)); ?>" class="btn--small"><?php echo app('translator')->get('Order Now'); ?></a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->
<?php /**PATH C:\xampp\htdocs\smm\application\resources\views/presets/default/sections/package.blade.php ENDPATH**/ ?>