<?php $__env->startSection('panel'); ?>

<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Name'); ?></th>
                                <th><?php echo app('translator')->get('Short Name'); ?></th>
                                <th><?php echo app('translator')->get('Url'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $apiProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e(__($item->name)); ?></td>
                                <td><?php echo e(__($item->short_name)); ?></td>
                                <td><?php echo e(__($item->api_url)); ?></td>
                                <td> <?php echo $item->statusBadge($item->status); ?></td>
                                <td>
                                    <button title="<?php echo app('translator')->get('Remove'); ?>"
                                    data-id="<?php echo e($item->id); ?>" data-name="<?php echo e($item->name); ?>" data-short_name="<?php echo e($item->short_name); ?>"
                                    data-api_url="<?php echo e($item->api_url); ?>" data-api_key="<?php echo e($item->api_key); ?>" data-status="<?php echo e($item->status); ?>"
                                        class="btn btn-sm btn--primary apiUpdate">
                                        <i class="las la-edit"></i>
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                            <?php endif; ?>

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            <?php if($apiProviders->hasPages()): ?>
            <div class="card-footer py-4">
                <?php echo e(paginateLinks($apiProviders)); ?>

            </div>
            <?php endif; ?>
        </div><!-- card end -->
    </div>
</div>



<div id="appiUpdateModel" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Update'); ?></h5>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.api.provider.update')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="form-group">
                        <label  for="name"> <?php echo app('translator')->get('Api Name'); ?>:</label>
                        <input type="text" class="form-control" name="name">
                    </div>
                    <div class="form-group">
                        <label  for="short_name"> <?php echo app('translator')->get('Api Short Name'); ?>:</label>
                        <input type="text" class="form-control" name="short_name">
                    </div>
                    <div class="form-group">
                        <label  for="api_ur"> <?php echo app('translator')->get('Api Url'); ?>:</label>
                        <input type="text" class="form-control" name="api_url">
                    </div>
                    <div class="form-group">
                        <label  for="api_key"> <?php echo app('translator')->get('Api Key'); ?>:</label>
                        <input type="text" class="form-control" name="api_key">
                    </div>
                    <div class="form-group">
                        <label> <?php echo app('translator')->get('Status'); ?></label>
                        <label class="switch m-0" for="statuss">
                            <input type="checkbox" class="toggle-switch" name="status" id="statuss">
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary btn-global"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.api.provider.create')); ?>" class="btn btn-sm btn--primary ">
    <?php echo app('translator')->get('Add Api Provider'); ?></a>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
<script>
    $('.apiUpdate').on('click', function () {
            var modal = $('#appiUpdateModel');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.find('input[name=name]').val($(this).data('name'));
            modal.find('input[name=short_name]').val($(this).data('short_name'));
            modal.find('input[name=api_url]').val($(this).data('api_url'));
            modal.find('input[name=api_key]').val($(this).data('api_key'));
            modal.find('input[name=status]').prop('checked', $(this).data('status') == 1 ? true : false );
            modal.find('input[name=status]').val($(this).data('status') == 1 ? 1 : 0);
            modal.modal('show');
        });
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smm\application\resources\views/admin/apiProvider/index.blade.php ENDPATH**/ ?>