<?php
$testimonial = getContent('testimonial.content',true);
$testimonialElements = getContent('testimonial.element',false);
?>
<!--========================== Testimonials Section Start ==========================-->
<section class="testimonials section-bg py-80 ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-10 position-relative">
                <div class="section-heading  text-center">
                    <span class="subtitle"><?php echo e(__(@$testimonial->data_values->top_heading)); ?></span>
                    <h2 class="section-heading__title ">
                        <?php echo e(__(@$testimonial->data_values->heading)); ?>

                    </h2>
                    <p class="section-heading__desc mb-30"><?php echo e(__(@$testimonial->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="testimonial-slider">
                <?php $__currentLoopData = $testimonialElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="testimonails-card">
                    <div class="testimonial-item">
                        <div class="testimonial-item__quate"><i class="fas fa-quote-right"></i></div>
                        <div class="testimonial-item__content">
                            <div class="testimonial-item__info">
                                <div class="testimonial-item__details">
                                    <h5 class="testimonial-item__name">
                                        <?php if(strlen(__(@$item->data_values->name)) >20): ?>
                                        <?php echo e(substr(__(@$item->data_values->name), 0,20).'...'); ?>

                                        <?php else: ?>
                                        <?php echo e(__(@$item->data_values->name)); ?>

                                        <?php endif; ?>
                                    </h5>
                                    <span class="testimonial-item__designation">
                                        <?php if(strlen(__(@$item->data_values->designation)) >30): ?>
                                        <?php echo e(substr(__(@$item->data_values->designation), 0,30).'...'); ?>

                                        <?php else: ?>
                                        <?php echo e(__(@$item->data_values->designation)); ?>

                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                            <p class="testimonial-item__desc">
                                <?php if(strlen(__(@$item->data_values->description)) >120): ?>
                                <?php echo e(substr(__(@$item->data_values->description), 0,120).'...'); ?>

                                <?php else: ?>
                                <?php echo e(__(@$item->data_values->description)); ?>

                                <?php endif; ?>
                            </p>
                            <div class="testimonial-item__rating">
                                <div class="testimonial-item__thumb">
                                    <img src="<?php echo e(getImage(getFilePath('testimonial').'/'.@$item->data_values->testimonial_image)); ?>"
                                        alt="image">
                                </div>
                                <ul class="rating-list">
                                    <li class="rating-list__item">
                                        <?php echo showRatings($item->data_values->star_count) ?>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<!--========================== Testimonials Section End ==========================-->
<?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/default/sections/testimonial.blade.php ENDPATH**/ ?>