
<?php $__env->startSection('panel'); ?>

<div class="row mb-none-30">
    <div class="col-lg-12 mb-30">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.order.update',$order->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row gy-2">
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="name"> <?php echo app('translator')->get('Status'); ?>:</label>
                                <?php
                                    echo $order->statusBadge($order->status);
                                ?>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Category'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e(@$order->category->name); ?>" readonly>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Service'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e(@$order->service->name); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Link'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($order->link); ?>"  readonly>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Quantity'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($order->quantity); ?>" readonly>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Interval'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($order->interval); ?>"
                                    placeholder="<?php echo app('translator')->get('Interval'); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Runs'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($order->runs); ?>"
                                    placeholder="<?php echo app('translator')->get('Runs'); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Remains'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($order->remains); ?>"
                                    placeholder="<?php echo app('translator')->get('Remains'); ?>" readonly>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Start Counter'); ?></label>
                                <input type="text" class="form-control" value="<?php echo e($order->start_count); ?>"
                                    placeholder="<?php echo app('translator')->get('Start Counter'); ?>" readonly>
                            </div>
                        </div>


                        <?php if(@$order->status == 0 || @$order->status == 1): ?>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Start Counter'); ?></label>
                                <input type="text" class="form-control" name="start_count"
                                    placeholder="<?php echo app('translator')->get('Start Counter'); ?>">
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="form-group">
                                <label for="name"> <?php echo app('translator')->get('Status'); ?>:</label>
                                <select name="status" class="form-control">
                                    <option value="0" <?php echo e(@$order->status == 0 ? 'selected' : ''); ?>><?php echo app('translator')->get('Pending'); ?>
                                    </option>
                                    <option value="1" <?php echo e(@$order->status == 1 ? 'selected' : ''); ?>><?php echo app('translator')->get('Processing'); ?>
                                    </option>
                                    <option value="2" <?php echo e(@$order->status == 2 ? 'selected' : ''); ?>><?php echo app('translator')->get('Completed'); ?>
                                    </option>
                                    <option value="3" <?php echo e(@$order->status == 3 ? 'selected' : ''); ?>><?php echo app('translator')->get('Cancelled'); ?>
                                    </option>
                                    <option value="4" <?php echo e(@$order->status == 4 ? 'selected' : ''); ?>><?php echo app('translator')->get('Refunded'); ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                        <?php elseif(@$order->status == 3 || @$order->status == 4): ?>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Reason'); ?></label>
                                <textarea cols="30" rows="10" readonly><?php echo e(__(@$order->reason??'N/A')); ?></textarea>
                            </div>
                        </div>
                        <?php endif; ?>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('User Note'); ?></label>
                               <textarea cols="30" rows="10"  readonly><?php echo e($order->note??'N/A'); ?></textarea>
                            </div>
                        </div>

                        <div id="reason-field" class="col-lg-12" style="display: none;">
                            <div class="form-group">
                                <label for="name" class="font-weight-bold"><?php echo app('translator')->get('Reason'); ?></label>
                                <textarea name="reason" id="reason" cols="30" rows="10"></textarea>
                            </div>
                        </div>

                        <?php if(@$order->status == 0 || @$order->status == 1): ?>
                        <div class="col-lg-12 ">
                            <div class="form-group float-end">
                                <button type="submit" class="btn btn--primary btn-block btn-lg">
                                    <?php echo app('translator')->get('Update'); ?></button>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    $(document).ready(function () {
        "use strict";
        $('#status').on('change',function () {
            var selectedStatus = $(this).val();
            if (selectedStatus == '3' || selectedStatus == '4') {
                $('#reason-field').show();
            } else {
                $('#reason-field').hide();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/admin/orders/edit.blade.php ENDPATH**/ ?>