
<?php $__env->startSection('content'); ?>
<div class="body-wrapper">
    <div class="table-content">
        <div class="m-0">
            <div class="list-card">
                <div class="row search-dash justify-content-end mb-3">
                    <div class="col-xl-3 col-lg-5 col-md-6 col-10"> <input type="text" class="form--control"
                            name="search_table" placeholder="<?php echo app('translator')->get('Search'); ?>...">
                        <i class="las la-search"></i>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Order No'); ?></th>
                                    <th><?php echo app('translator')->get('Service Name'); ?></th>
                                    <th><?php echo app('translator')->get('Link'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="text-center">
                                    <td data-label="<?php echo app('translator')->get('Order No'); ?>">#<?php echo e($item->order_no); ?></td>
                                    <td data-label="<?php echo app('translator')->get('Service Name'); ?>">
                                        <?php if(strlen(__(@$item->service->name)) >30): ?>
                                        <?php echo e(substr( __(@$item->service->name), 0,30).'...'); ?>

                                        <?php else: ?>
                                        <?php echo e(__(@$item->service->name)); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Link'); ?>">
                                        <a href="<?php echo e($item->link); ?>" target="_blank" class="text--base"><?php echo e($item->link); ?></a>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Price'); ?>"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($item->price)); ?>

                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php
                                        echo $item->statusBadge($item->status);
                                        ?>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <button class="btn btn--base btn--sm detailsModalBtn" data-start_count="<?php echo e($item->start_count); ?>" data-remains="<?php echo e($item->remains); ?>" data-name="<?php echo e(@$item->service->name); ?>" title="<?php echo app('translator')->get('Details'); ?>"><i class="fas fa-eye"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%" data-label="<?php echo app('translator')->get('Order Table'); ?>">
                                        <?php echo e(__($emptyMessage)); ?>

                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-5">
                        <?php if($orders->hasPages()): ?>
                        <div class="py-4">
                            <?php echo e(paginateLinks($orders)); ?>

                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



<div id="detailsModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Order Details'); ?></h5>
                <button type="button" class="close btn btn--sm btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <div class="modal-body">
                    <p><strong><?php echo app('translator')->get('Service Name'); ?>:</strong> <span class="serviceName"></span></p>
                    <p><strong><?php echo app('translator')->get('Start Counter'); ?>:</strong> <span class="start_count"></span></p>
                    <p><strong><?php echo app('translator')->get('Remains'); ?>:</strong> <span class="remains"></span></p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function ($) {
            "use strict";

            $('.detailsModalBtn').on('click', function () {
                var modal = $('#detailsModal');
                modal.find('.serviceName').text($(this).data('name'));
                modal.find('.start_count').text($(this).data('start_count'));
                modal.find('.remains').text($(this).data('remains'));
                modal.modal('show');
            });

            $('.custom-table').css('padding-top', '0px');
            var tr_elements = $('.custom-table tbody tr');

            $(document).on('input', 'input[name=search_table]', function () {
                "use strict";

                var search = $(this).val().toUpperCase();
                var match = tr_elements.filter(function (idx, elem) {
                    return $(elem).text().trim().toUpperCase().indexOf(search) >= 0 ? elem : null;
                }).sort();
                var table_content = $('.custom-table tbody');
                if (match.length == 0) {
                    table_content.html('<tr><td colspan="100%" class="text-center">Data Not Found</td></tr>');
                } else {
                    table_content.html(match);
                }
            });

    })(jQuery);

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/user/orders/index.blade.php ENDPATH**/ ?>