
<?php $__env->startSection('panel'); ?>
<div class="row mb-3">
    <div class="col-lg-12">
        <div class="d-flex flex-wrap gap-4 justify-content-end">
            <a href="<?php echo e(route('admin.services.create')); ?>" class="btn btn-sm btn--primary"><i class="fas fa-plus"></i> <?php echo app('translator')->get('Add Service'); ?></a>
            <button class="btn btn-sm btn--primary box--shadow1" id="actionButton" data-bs-toggle="dropdown">
                <i class="fas fa-plus"></i>
                <?php echo app('translator')->get('Add API Services'); ?>
            </button>
            <div class="dropdown-menu p-0">
                <?php $__currentLoopData = $apiProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apiList): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('admin.services.get.api', $apiList->id)); ?>" class="dropdown-item">
                    <i class="las la-cloud-download-alt"></i>
                    <?php echo e(__($apiList->name)); ?>

                </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="show-filter mb-3 text-end">
            <button type="button" class="btn btn--primary showFilterBtn btn-sm"><i class="las la-filter"></i>
                <?php echo app('translator')->get('Filter'); ?></button>
        </div>
        <div class="card responsive-filter-card mb-4">
            <div class="card-body">
                <form action="<?php echo e(route('admin.services.filter')); ?>" method="get">
                    <div class="d-flex flex-wrap gap-4">
                        <div class="flex-grow-1">
                            <label><?php echo app('translator')->get('Name Search'); ?></label>
                            <input type="text" name="search" class="form-control"
                                placeholder="<?php echo app('translator')->get('Type Here'); ?>">
                        </div>
                        <div class="flex-grow-1">
                            <label><?php echo app('translator')->get('Category'); ?></label>
                            <select name="category" id="category" class="form-control">
                                <option value=""><?php echo app('translator')->get('Select Category'); ?></option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php if(@request()->category == $category->id): ?> selected <?php endif; ?>><?php echo app('translator')->get($category->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="flex-grow-1">
                            <label><?php echo app('translator')->get('Provider'); ?></label>
                            <select name="provider" id="provider" class="form-control">
                                <option value=""><?php echo app('translator')->get('Select Provider'); ?></option>
                                <?php $__currentLoopData = $apiProviders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($provider->id); ?>" <?php if(@request()->provider == $provider->id): ?> selected <?php endif; ?>><?php echo app('translator')->get($provider->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="flex-grow-1 align-self-end">
                            <button type="submit" class="btn btn--primary h-40 w-100"><i class="fas fa-check"></i><?php echo app('translator')->get('Apply'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('S/N'); ?></th>
                                <th><?php echo app('translator')->get('Category Name'); ?></th>
                                <th><?php echo app('translator')->get('Service Name'); ?></th>
                                <th><?php echo app('translator')->get('Provider'); ?></th>
                                <th><?php echo app('translator')->get('Price'); ?></th>
                                <th><?php echo app('translator')->get('Drip Feed'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td> <?php echo e($key+1); ?></td>
                                <td>
                                    <span title="<?php echo e(@$item->category->name); ?>">
                                        <?php if(strlen(__(@$item->category->name)) >40): ?>
                                        <?php echo e(substr(__(@$item->category->name), 0,40).'...'); ?>

                                        <?php else: ?>
                                        <?php echo e(__(@$item->category->name)); ?>

                                        <?php endif; ?>
                                    </span>
                                </td>

                                <td>
                                    <span title="<?php echo e(@$item->name); ?>">
                                        <?php if(strlen(__($item->name)) >40): ?>
                                        <?php echo e(substr(__($item->name), 0,40).'...'); ?>

                                        <?php else: ?>
                                        <?php echo e(__($item->name)); ?>

                                        <?php endif; ?>
                                    </span>
                                </td>

                                <td>
                                    <?php if(@$item->provider->name): ?>
                                    <span class="badge badge--primary" title="Api Provider">
                                        <?php echo e(__(@$item->provider->name)); ?></span>
                                    <?php else: ?>
                                    <span class="badge badge--warning"><?php echo app('translator')->get('Manual'); ?></span>
                                    <?php endif; ?>
                                </td>

                                <td><?php echo e($general->cur_sym); ?> <?php echo e(showAmount($item->price)); ?></td>

                                <td>
                                    <?php
                                      echo $item->drip_feedBadge($item->status);
                                    ?>
                                </td>

                                <td>
                                    <?php
                                    echo $item->statusBadge($item->status);
                                    ?>
                                </td>

                                <td>
                                    <a href="<?php echo e(route('admin.services.edit',$item->id)); ?>" title="<?php echo app('translator')->get('Edit'); ?>" data-id="<?php echo e($item->id); ?>" class="btn btn-sm btn--primary"><i class="las la-edit"></i></a>
                                    <button title="<?php echo app('translator')->get('Status Change'); ?>" data-id="<?php echo e($item->id); ?>" data-status="<?php echo e($item->status); ?>" class="btn btn-sm btn--danger statusChangeBtn"><i class="fas fa-sync-alt"></i></button>
                                    <button title="<?php echo app('translator')->get('Details'); ?>" data-min="<?php echo e($item->min); ?>" data-max="<?php echo e($item->max); ?>" data-details="<?php echo e($item->details); ?>" data-name="<?php echo e($item->name); ?>" class="btn btn-sm btn--info detailsBtn"><i class="las la-eye"></i></button>
                                </td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                            <?php endif; ?>

                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            <?php if($services->hasPages()): ?>
            <div class="card-footer py-4">
                <?php echo e(paginateLinks($services)); ?>

            </div>
            <?php endif; ?>
        </div><!-- card end -->
    </div>
</div>


<div id="statusChangeModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Status Change Confirmation!'); ?></h5>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.services.status.change')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for=""><?php echo app('translator')->get('Status'); ?></label>
                            <select name="status" class="form-control">
                                <option <?php if(1): ?> selected <?php endif; ?> value="1"><?php echo app('translator')->get('Active'); ?></option>
                                <option <?php if(0): ?> selected <?php endif; ?> value="0"><?php echo app('translator')->get('Inactive'); ?></option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Confirm'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>




<div class="modal fade" id="detailsModal">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="title"></h4>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <p> <strong><?php echo app('translator')->get('Details'); ?>:</strong><span id="servicedescription"></span></p>
                <p><strong><?php echo app('translator')->get('min'); ?>:</strong> <span id="min"></span></p>
                <p><strong><?php echo app('translator')->get('max'); ?> :</strong> <span id="max"></span></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="close btn btn--primary" data-bs-dismiss="modal" aria-label="Close">
                    <?php echo app('translator')->get('Close'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    "use strict";

        $('.statusChangeBtn').on('click', function () {
            var modal = $('#statusChangeModal');
            modal.find('input[name=id]').val($(this).data('id'));
            var status = $(this).data('status');
            modal.find('select[name=status]').val(status);
            modal.modal('show');
        });


        // details
        $('.detailsBtn').on('click', function () {
            var modal = $('#detailsModal');
            var title = $(this).data('name');
                var description = $(this).data('details');
                var min = $(this).data('min');
                var max = $(this).data('max');
                $('#title').text(title);
                $('#servicedescription').text(description);
                $('#min').text(min);
                $('#max').text(max);

            modal.modal('show');
        });

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/admin/services/index.blade.php ENDPATH**/ ?>