<?php
    $links = getContent('policy_pages.element');
    $importantLinks = getContent('footer_important_links.element', false, null, true);
    $companyLinks = getContent('footer_company_links.element', false, null, true);
    $subscribe = getContent('subscribe.content', true);
    $contact = getContent('contact_us.content',true);
    $socialIcons = getContent('social_icon.element',false);
?>
<!-- Footer -->
<!-- ==================== Footer Start ==================== -->
<footer class="footer-area pt-120">
    <div class="container">
        <div class="row justify-content-center g-5">
            <div class="col-xl-3 col-sm-6">
                <div class="footer-item">
                    <div class="footer-item__logo">
                        <a href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo.png', '?'.time())); ?>" alt="<?php echo e(config('app.name')); ?>">
                        </a>
                    </div>
                    <p class="footer-item__desc">
                        <?php if(strlen(__(strip_tags(@$contact->data_values->short_description))) > 60): ?>
                        <?php echo e(substr(__(strip_tags(@$contact->data_values->short_description)), 0, 60) . '...'); ?>

                        <?php else: ?>
                            <?php echo e(__(strip_tags(@$contact->data_values->short_description))); ?>

                        <?php endif; ?>
                    </p>
                    <ul class="social-list mt-3">
                        <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="social-list__item"><a href="<?php echo e($item->data_values->url); ?>" class="social-list__link"><?php echo $item->data_values->social_icon; ?></a> </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <div class="col-xl-2 col-sm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title"><?php echo app('translator')->get('Important Links'); ?></h5>
                    <ul class="footer-menu">
                        <?php $__currentLoopData = $importantLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="footer-menu__item"><a href="<?php echo e(url('/').$item->data_values->url); ?>" class="footer-menu__link"><?php echo e(__(@$item->data_values->title)); ?> </a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>

            <div class="col-xl-2 col-sm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title"><?php echo app('translator')->get('Company Links'); ?></h5>
                    <ul class="footer-menu">
                        <?php $__currentLoopData = $companyLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="footer-menu__item"><a href="<?php echo e(url('/').$item->data_values->url); ?>" class="footer-menu__link"><?php echo e(__(@$item->data_values->title)); ?> </a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="footer-menu__item"><a href="<?php echo e(route('policy.pages', [slug($link->data_values->title), $link->id])); ?>" class="footer-menu__link"><?php echo e(__(@$link->data_values->title)); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <li class="footer-menu__item"><a href="<?php echo e(url('/cookie-policy')); ?>" class="footer-menu__link"><?php echo app('translator')->get('Cookie Policy'); ?></a></li>
                    </ul>
                </div>
            </div>

             <div class="col-xl-2 col-sm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title"><?php echo app('translator')->get('Address'); ?></h5>
                    <ul class="footer-menu">
                        <li class="footer-menu__item"><a href="tel:<?php echo e($contact->data_values->contact_number); ?>"><?php echo e($contact->data_values->contact_number); ?></a></li>
                        <li class="footer-menu__item"><a href="mailto:<?php echo e($contact->data_values->email_address); ?>"><?php echo e($contact->data_values->email_address); ?></a></li>
                        <li class="footer-menu__item">
                            <?php echo e(__(@$contact->data_values->contact_details)); ?>

                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title"><?php echo app('translator')->get('Newsletter'); ?></h5>
                    <p><?php echo app('translator')->get('Subscribe our latest update'); ?></p>
                    <form action="<?php echo e(route('subscribe')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <input type="text" class="form--control" name="email" placeholder="<?php echo app('translator')->get('Email'); ?>">
                            <button type="submit">
                                <i class="fas fa-paper-plane"></i>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="copyright">
        <?php echo $contact->data_values->website_footer; ?>
    </div>
</footer>
<!-- ==================== Footer End ==================== -->
<?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/components/footer.blade.php ENDPATH**/ ?>