<!doctype html>
<html lang="<?php echo e(config('app.locale')); ?>" itemscope itemtype="http://schema.org/WebPage">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> <?php echo e($general->siteName(__($pageTitle))); ?></title>
    <?php echo $__env->make('includes.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Bootstrap CSS -->
    <link href="<?php echo e(asset('assets/common/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/common/css/all.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/common/css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/magnific-popup.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/odometer.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lightcase.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/main.css')); ?>">
    <?php echo $__env->yieldPushContent('style-lib'); ?>
    <?php echo $__env->yieldPushContent('style'); ?>

    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/color.php')); ?>?color1=<?php echo e($general->theme_two_base_color); ?>&color2=<?php echo e($general->secondary_color); ?>">
</head>
<body class="<?php echo e($general->rtl==1?'rtl':'ltr'); ?>">

<?php echo $__env->make($activeTemplate.'components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make($activeTemplate.'components.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php if(request()->route()->uri != '/'): ?>
<?php echo $__env->make($activeTemplate.'components.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php echo $__env->yieldContent('content'); ?>
<?php echo $__env->make($activeTemplate.'components.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make($activeTemplate.'components.cookie', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Optional JavaScript -->
<!-- jQuery first, then Popper.js, then Bootstrap JS -->
  <script src="<?php echo e(asset('assets/common/js/jquery-3.7.1.min.js')); ?>"></script>
  <script src="<?php echo e(asset('assets/common/js/bootstrap.bundle.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/popper.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/slick.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/jquery.magnific-popup.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/odometer.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/viewport.jquery.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/smoothscroll.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/lightcase.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/wow.min.js')); ?>"></script>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/main.js')); ?>"></script>

<?php echo $__env->yieldPushContent('script-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make('includes.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('includes.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script>
    (function ($) {
        "use strict";
        $(".langSel").on("change", function() {
            window.location.href = "<?php echo e(route('home')); ?>/change/"+$(this).val() ;
        });

        var inputElements = $('input,select');
        $.each(inputElements, function (index, element) {
            element = $(element);
            element.closest('.form-group').find('label').attr('for',element.attr('name'));
            element.attr('id',element.attr('name'))
        });

        $('.policy').on('click',function(){
            $.get('<?php echo e(route('cookie.accept')); ?>', function(response){
                $('.cookies-card').addClass('d-none');
            });
        });

        setTimeout(function(){
            $('.cookies-card').removeClass('hide')
        },2000);


    })(jQuery);
</script>

</body>
</html>
<?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/themeTwo/layouts/frontend.blade.php ENDPATH**/ ?>