@php
    $testimonial = getContent('testimonial.content',true);
    $testimonialElements = getContent('testimonial.element',false);
@endphp
<!--========================== Testimonial Start ==========================-->
<section class="testimonial py-80">
    <div class="container">
        <div class="title">
            <h4> {{__(@$testimonial->data_values->heading)}}</h4>
            <p>{{__(@$testimonial->data_values->subheading)}}</p>
        </div>
        <div class="testimonial-slider">
            @foreach($testimonialElements as $item)
            <div class="card">
                <div class="profile d-flex">
                    <div>
                        <img src="{{getImage(getFilePath('testimonial').'/'.@$item->data_values->testimonial_image)}}" alt="@lang('image')">
                    </div>
                    <div>
                        <h5>
                            @if(strlen(__(@$item->data_values->name)) >20)
                            {{substr(__(@$item->data_values->name), 0,20).'...' }}
                            @else
                            {{__(@$item->data_values->name)}}
                            @endif
                        </h5>
                        <p> @if(strlen(__(@$item->data_values->designation)) >30)
                            {{substr(__(@$item->data_values->designation), 0,30).'...' }}
                            @else
                            {{__(@$item->data_values->designation)}}
                            @endif
                        </p>
                    </div>
                </div>
                <div class="content">
                    <p> @if(strlen(__(@$item->data_values->description)) >120)
                        {{substr(__(@$item->data_values->description), 0,120).'...' }}
                        @else
                        {{__(@$item->data_values->description)}}
                        @endif
                    </p>
                </div>
                <div class="star">
                    @php echo showRatings($item->data_values->star_count) @endphp
                </div>
            </div>
            @endforeach
        </div>
    </div>
</section>
<!--========================== Testimonial End ==========================-->
