@extends($activeTemplate.'layouts.master')
@section('content')
<div class="body-wrapper">
    <div class="table-content">
        <div class="m-0">
            <div class="list-card">
                <div class="row search-dash justify-content-end mb-3">
                    <div class="col-xl-3 col-lg-5 col-md-6 col-10"> <input type="text" class="form--control"
                            name="search_table" placeholder="@lang('Search')...">
                        <i class="las la-search"></i>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-xl-12">
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th>@lang('Package Name')</th>
                                    <th>@lang('Link')</th>
                                    <th>@lang('Price')</th>
                                    <th>@lang('Status')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($brandPackageOrder as $item)
                                <tr>
                                    <td data-label="@lang('Brand Package Name')">{{ __($item->name) }}</td>

                                    @if($item->link)
                                    <td data-label="@lang('Links')">
                                        @foreach(json_decode($item->link) as $key=>$value)
                                        <a href="{{$value}}" target="_blank">{{$value}}</a>
                                        <br><br>
                                        @endforeach
                                    </td>
                                    @endif

                                    <td data-label="@lang('Price')">{{$general->cur_sym}}{{ showAmount($item->price) }}
                                    </td>

                                    <td data-label="@lang('Status')">
                                        @php
                                        echo $item->statusBadge($item->status);
                                        @endphp
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td class="text-muted text-center" colspan="100%" data-label="Package Table">
                                        {{__($emptyMessage) }}</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-5">
                        @if ($brandPackageOrder->hasPages())
                        <div class="py-4">
                            {{ paginateLinks($brandPackageOrder) }}
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection

@push('script')
<script>
    (function ($) {
            "use strict";

            $('.custom-table').css('padding-top', '0px');
            var tr_elements = $('.custom-table tbody tr');

            $(document).on('input', 'input[name=search_table]', function () {
                "use strict";

                var search = $(this).val().toUpperCase();
                var match = tr_elements.filter(function (idx, elem) {
                    return $(elem).text().trim().toUpperCase().indexOf(search) >= 0 ? elem : null;
                }).sort();
                var table_content = $('.custom-table tbody');
                if (match.length == 0) {
                    table_content.html('<tr><td colspan="100%" class="text-center">Data Not Found</td></tr>');
                } else {
                    table_content.html(match);
                }
            });

    })(jQuery);

</script>
@endpush
