<?php
$user = auth()->user();
?>
<div class="col-xl-3 col-lg-4 pe-xl-4">
    <div class="dashboard_profile">
        <div class="dashboard_profile__details">
            <div class="sidebar-menu">
                    <span class="sidebar-menu__close"><i class="las la-times"></i></span>
                    <ul class="sidebar-menu-list">
                        <div class="dashboard_profile_wrap">
                            <div class="profile_photo">
                                <img src="<?php echo e(getImage(getFilePath('userProfile').'/'.$user->image,getFileSize('userProfile'))); ?>" alt="agent">
                                <div class="photo_upload">
                                    <form action="<?php echo e(route('user.profile.update')); ?>" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <label for="image"><i class="fas fa-image"></i></label>
                                        <input id="image" type="file" name="image" class="upload_file"  onchange="this.form.submit()">
                                  </form>
                                </div>
                            </div>
                            <h3 class="text-center"><?php echo e(__(@$user->fullname)); ?></h3>
                        </div>

                        <li class="sidebar-menu-list__item <?php echo e(Route::is('user.home') ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('user.home')); ?>" class="sidebar-menu-list__link">
                            <span class="icon"><i class="fa fa-tachometer-alt"></i></span>
                            <?php echo app('translator')->get('Dashboard'); ?></span>
                            </a>
                        </li>

                        <li class="sidebar-menu-list__item has-dropdown">
                            <a href="javascript:void(0)" class="sidebar-menu-list__link">
                            <span class="icon"><i class="fas fa-plus"></i></span>
                            <span class="text"><?php echo app('translator')->get('Create Orders'); ?></span>
                            </a>
                            <div class="sidebar-submenu">
                                <ul class="sidebar-submenu-list">
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.order.create') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.order.create')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('New Order'); ?></a>
                                    </li>

                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.mass.order.create') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.mass.order.create')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Mass Order'); ?></a>
                                    </li>

                                </ul>
                            </div>
                        </li>

                        <li class="sidebar-menu-list__item has-dropdown">
                            <a href="javascript:void(0)" class="sidebar-menu-list__link">
                            <span class="icon"><i class="fas fa-cart-plus"></i></span>
                            <span class="text"><?php echo app('translator')->get('Orders'); ?></span>
                            </a>
                            <div class="sidebar-submenu">
                                <ul class="sidebar-submenu-list">
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.brnad.package.index') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.brnad.package.index')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Brand Package Orders'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.order.index') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.order.index')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('All Orders'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.order.pending') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.order.pending')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Pending'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.order.processing') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.order.processing')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Processing'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.order.complete') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.order.complete')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Complete'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.order.refund') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.order.refund')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Refunded'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.order.cancelle') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.order.cancelle')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Cancelled'); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </li>

                        <li class="sidebar-menu-list__item has-dropdown">
                            <a href="javascript:void(0)" class="sidebar-menu-list__link">
                            <span class="icon"><i class="fas fa-file-invoice-dollar"></i></span>
                            <span class="text"><?php echo app('translator')->get('Deposit'); ?></span>
                            </a>
                            <div class="sidebar-submenu">
                                <ul class="sidebar-submenu-list">
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.deposit') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.deposit')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Deposit Now'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.deposit.history') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.deposit.history')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Deposit Log'); ?> </a>
                                    </li>
                                </ul>
                            </div>
                        </li>

                        <li class="sidebar-menu-list__item has-dropdown">
                            <a href="javascript:void(0)" class="sidebar-menu-list__link">
                            <span class="icon"><i class="fas fa-headset"></i></span>
                            <span class="text"><?php echo app('translator')->get('Support Tickets'); ?></span>
                            </a>
                            <div class="sidebar-submenu">
                                <ul class="sidebar-submenu-list">
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('ticket') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('ticket')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('My Tickets'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('ticket.open') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('ticket.open')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('New Ticket'); ?> </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                        <li class="sidebar-menu-list__item <?php echo e(Route::is('user.transactions') ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('user.transactions')); ?>" class="sidebar-menu-list__link">
                            <span class="icon"><i class="fas fa-funnel-dollar"></i></span>
                            <?php echo app('translator')->get('Transactions'); ?></span>
                            </a>
                        </li>
                        <li class="sidebar-menu-list__item has-dropdown">
                            <a href="javascript:void(0)" class="sidebar-menu-list__link">
                            <span class="icon"><i class="fas fa-cog"></i></span>
                            <span class="text"><?php echo app('translator')->get('Settings'); ?></span>
                            </a>
                            <div class="sidebar-submenu">
                                <ul class="sidebar-submenu-list">
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.profile.setting') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.profile.setting')); ?>" class="sidebar-submenu-list__link"> <?php echo app('translator')->get('Profile Setting'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.change.password') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.change.password')); ?>" class="sidebar-submenu-list__link"><?php echo app('translator')->get('Change Password'); ?></a>
                                    </li>
                                    <li class="sidebar-submenu-list__item <?php echo e(Route::is('user.twofactor') ? 'active' : ''); ?>">
                                        <a href="<?php echo e(route('user.twofactor')); ?>" class="sidebar-submenu-list__link">   <?php echo app('translator')->get('Google Authentication'); ?></a>
                                    </li>
                                </ul>
                            </div>
                        </li>

                        <li class="sidebar-menu-list__item <?php echo e(Route::is('user.api.index') ? 'active' : ''); ?>">
                            <a href="<?php echo e(route('user.api.index')); ?>" class="sidebar-menu-list__link">
                            <span class="icon"><i class="fas fa-code"></i></span>
                            <?php echo app('translator')->get('Api'); ?></span>
                            </a>
                        </li>
                        <li class="sidebar-menu-list__item">
                            <a href="<?php echo e(route('user.logout')); ?>" class="sidebar-menu-list__link text--danger">
                            <span class="icon"><i class="fas fa-sign-out-alt"></i></span>
                            <?php echo app('translator')->get('Logout'); ?></span>
                            </a>
                        </li>
                    </ul>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/default/components/side_nav.blade.php ENDPATH**/ ?>