
<?php $__env->startSection('content'); ?>
<div class="col-xl-9 col-lg-12">
    <div class="dashboard-body">
        <div class="dashboard-body__bar">
            <span class="dashboard-body__bar-icon"><i class="las la-bars"></i></span>
        </div>
        <div class="row gy-4 justify-content-center">
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <div class="dashboard-card">
                    <span class="banner-effect-1"></span>
                    <div class="dashboard-card__icon">
                        <i class="las la-hand-holding-usd"></i>
                    </div>
                    <div class="dashboard-card__content">
                        <h5 class="dashboard-card__title"><?php echo app('translator')->get('Balance'); ?></h5>
                        <h4 class="dashboard-card__amount"><?php echo e($general->cur_sym); ?><?php echo e(showAmount($user->balance)); ?></h4>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="<?php echo e(route('user.order.index')); ?>">
                <div class="dashboard-card">
                    <span class="banner-effect-1"></span>
                    <div class="dashboard-card__icon">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="dashboard-card__content">
                        <h5 class="dashboard-card__title"><?php echo app('translator')->get('Orders'); ?> </h5>
                        <h4 class="dashboard-card__amount"><?php echo e($orderCount); ?></h4>
                    </div>
                </div>
                </a>
            </div>
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="<?php echo e(route('user.brnad.package.index')); ?>">
                <div class="dashboard-card">
                    <span class="banner-effect-1"></span>
                    <div class="dashboard-card__icon">
                        <i class="fas fa-cart-plus"></i>
                    </div>
                    <div class="dashboard-card__content">
                        <h5 class="dashboard-card__title"><?php echo app('translator')->get('Brand Package Orders'); ?> </h5>
                        <h4 class="dashboard-card__amount"><?php echo e($brandOrderCount); ?></h4>
                    </div>
                </div>
                </a>
            </div>
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="<?php echo e(route('user.transactions')); ?>">
                    <div class="dashboard-card">
                        <span class="banner-effect-1"></span>
                        <div class="dashboard-card__icon">
                            <i class="fas fa-funnel-dollar"></i>
                        </div>
                        <div class="dashboard-card__content">
                            <h5 class="dashboard-card__title"><?php echo app('translator')->get('Transactions'); ?></h5>
                            <h4 class="dashboard-card__amount"><?php echo e($transectionCount); ?></h4>
                        </div>
                    </div>
                </a>
            </div>

            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="<?php echo e(route('user.deposit.history')); ?>">
                    <div class="dashboard-card">
                        <span class="banner-effect-1"></span>
                        <div class="dashboard-card__icon">
                            <i class="fas fa-clipboard-check"></i>
                        </div>
                        <div class="dashboard-card__content">
                            <h5 class="dashboard-card__title"><?php echo app('translator')->get('Deposit Log'); ?></h5>
                            <h4 class="dashboard-card__amount"><?php echo e($depositCount); ?></h4>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-xl-4 col-lg-4 col-sm-4">
                <a class="d-block" href="<?php echo e(route('ticket')); ?>">
                    <div class="dashboard-card">
                        <span class="banner-effect-1"></span>
                        <div class="dashboard-card__icon">
                            <i class="fas fa-clipboard-check"></i>
                        </div>
                        <div class="dashboard-card__content">
                            <h5 class="dashboard-card__title"><?php echo app('translator')->get('Tickets'); ?></h5>
                            <h4 class="dashboard-card__amount"><?php echo e($ticketCount); ?></h4>
                        </div>
                    </div>
                </a>
            </div>
        </div>

        <div class="row mb-4 mt-4">
            <div class="col-12">
                <div class="chart account-form">
                    <div class="chart-bg">
                        <h5><?php echo app('translator')->get('Monthly Deposit History'); ?></h5>
                        <div id="account-chart"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/admin/js/apexcharts.min.js')); ?>"></script>
<script>
    (function () {
        "use strict";
        var options = {
            chart: {
                type: 'area',
                stacked: false,
                height: '310px'
            },
            stroke: {
                width: [0, 3],
                curve: 'smooth'
            },
            plotOptions: {
                bar: {
                    columnWidth: '50%'
                }
            },
            colors: ['#00adad', '#67BAA7'],
            series: [{
        name: '<?php echo app('translator')->get("Deposits"); ?>',
        type: 'area',
        data: <?php echo json_encode($depositsChart['values'], 15, 512) ?>
    }],
    fill: {
        opacity: [0.85, 1],
                },
    labels: <?php echo json_encode($depositsChart['labels'], 15, 512) ?>,
    markers: {
        size: 0
    },
    xaxis: {
        type: 'text'
    },
    yaxis: {
        min: 0
    },
    tooltip: {
        shared: true,
            intersect: false,
                y: {
            formatter: function (y) {
                if (typeof y !== "undefined") {
                    return "$ " + y.toFixed(0);
                }
                return y;

            }
        }
    },
    legend: {
        labels: {
            useSeriesColors: true
        },
        markers: {
            customHTML: [
                function () {
                    return ''
                },
                function () {
                    return ''
                }
            ]
        }
    }
            }
    var chart = new ApexCharts(
        document.querySelector("#account-chart"),
        options
    );
    chart.render();
    }) ();
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtechscom/public_html/smm.webtechs.com.ng/application/resources/views/presets/default/user/dashboard.blade.php ENDPATH**/ ?>